﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CashierCrisis.Managers;
using CashierCrisis.Entities;
using Microsoft.Xna.Framework.Graphics;
using System.Diagnostics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace CashierCrisis.Scenes
{
    public class PlayScene : Scene
    {
        private InputManager input;
        private EntityManager entityManager;
        
        private bool isPaused = false;
        private bool showGraph = false;
        Texture2D backgroundTexture;
        Stage currentStage;
        Song song;

        public PlayScene(Game game):
            base(game)
        {
            input = CashierGame.Instance.Services.GetService(typeof(InputManager)) as InputManager;
            entityManager = CashierGame.Instance.Services.GetService(typeof(EntityManager)) as EntityManager;
           
            Unpause();
        }

        public override void LoadContent()
        {
            backgroundTexture = Content.Load<Texture2D>("Sprites//Stores//store2-b");
            currentStage = new Stage();
            currentStage.Initialize(Content);
            Log.WriteLine(LogCategory.Game, "Player Created");
            AudioManager.LoadMusicContent(Content, "Audio\\Music\\StoreSymphony", "Store");
            song = AudioManager.PlayMusic("Store");
            MediaPlayer.IsRepeating = true;
            Unpause();
            base.LoadContent();
        }

        
        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {

            if (input.PauseButton())
            {
                if (!isPaused)
                {
                    PauseGame();
                }
                else
                {
                    if (isPaused)
                        Unpause();
                }
            }

            if(input.IsNewButtonPress(Buttons.LeftShoulder) || input.IsNewKeyPress(Keys.G))
            {
                showGraph = !showGraph;
            }

            if (showGraph)
            {
                if (!UIManager.IsShowing("Graph") && !UIManager.IsShowing("Pause"))
                {
                    UIManager.PushUserInterface("Graph");
                }
            }
            else
            {
                if (UIManager.IsShowing("Graph"))
                {
                    UIManager.PopUserInterface();
                }
            }
             
            currentStage.Update(gameTime);
            DebugInputUpdate();
            base.Update(gameTime);
        }

        #region Debug Input
        [Conditional("DEBUG")]
        public void DebugInputUpdate()
        {
            if (input.IsNewKeyPress(Keys.M))
            {
                currentStage.ToggleGrowth();
                Log.WriteLine(LogCategory.Game, "Mood Growth Toggled.");
            }

            if (input.IsNewKeyPress(Keys.N))
            {
                currentStage.ToggleDecay();
                Log.WriteLine(LogCategory.Game, "Mood Decay Toggled.");
            }
            
          if(input.IsKeyPressed(Keys.M) && input.IsNewKeyPress(Keys.OemMinus))
          {
              currentStage.DecreaseMoodGrowthRate(1);
              Log.WriteLine(LogCategory.Game, "Decreased Mood Growth Rate by 1");
          }

          if (input.IsKeyPressed(Keys.M) && input.IsNewKeyPress(Keys.OemPlus))
          {
              currentStage.IncreaseMoodGrowthRate(1);
              Log.WriteLine(LogCategory.Game, "Increased Mood Growth Rate by 1");
          }

          if (input.IsKeyPressed(Keys.N) && input.IsNewKeyPress(Keys.OemPlus))
          {
              currentStage.IncreaseMoodDecayRate(1);
              Log.WriteLine(LogCategory.Game, "Increased Mood Decay Rate by 1");
          }

          if (input.IsKeyPressed(Keys.N) && input.IsNewKeyPress(Keys.OemMinus))
          {
              currentStage.DecreaseMoodGrowthRate(1);
              Log.WriteLine(LogCategory.Game, "Decreased Mood Growth by 1.");
          }

          if (input.IsKeyPressed(Keys.S) && input.IsNewKeyPress(Keys.OemPlus))
          {
              currentStage.IncreaseSpeed(1);
              Log.WriteLine(LogCategory.Game, "Increased Speed by 1.");
          }

          if (input.IsKeyPressed(Keys.S) && input.IsNewKeyPress(Keys.OemMinus))
          {
              currentStage.DecreaseSpeed(1);
              Log.WriteLine(LogCategory.Game, "Decreased Speed by 1.");
          }

          if (input.IsKeyPressed(Keys.I) && input.IsNewKeyPress(Keys.OemPlus))
          {
              currentStage.IncreaseInterval(5);
              Log.WriteLine(LogCategory.Game, "Increased Interval by 5.");
          }

          if (input.IsKeyPressed(Keys.I) && input.IsNewKeyPress(Keys.OemMinus))
          {
              currentStage.DecreaseInterval(5);
              Log.WriteLine(LogCategory.Game, "Decreased Interval by 5.");
          }

        }
        #endregion


        public override void Draw(SpriteBatch spriteBatch)
        {
            spriteBatch.Draw(backgroundTexture, SceneManager.ScreenRectangle, Color.White);
            base.Draw(spriteBatch);
        }

        // Pause methods.
        public void PauseGame()
        {
            isPaused = true;
            entityManager.Paused(isPaused);
            UIManager.PushUserInterface("Pause");
            Log.WriteLine(LogCategory.Game, "Paused");
        }

        public void Unpause()
        {
            isPaused = false;
            entityManager.Paused(isPaused);
            
            if (UIManager.IsShowing("Pause"))
            {
                UIManager.PopUserInterface();
            }
            Log.WriteLine(LogCategory.Game, "Unpaused");
        }

        public override void UnloadContent()
        {
            MediaPlayer.Stop();
            base.UnloadContent();
        }
    }
}
